/*
 * Decompiled with CFR 0.152.
 */
package adboards;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import tools.LoggerService;
import tools.PaletteService;

public class AdboardsToBmpConverter {
    private final LoggerService logger;
    private final PaletteService paletteService;

    public AdboardsToBmpConverter(LoggerService logger, PaletteService paletteService) {
        this.logger = logger;
        this.paletteService = paletteService;
    }

    public void convert(byte[] fileContent, int Width, int Height, String outputPath) throws IOException {
        BufferedImage img = new BufferedImage(Width, Height, 1);
        int x = 0;
        int y = 0;
        for (int i = 0; i < fileContent.length; ++i) {
            this.logger.log("Processing line #" + y);
            String hex = Integer.toHexString(fileContent[i]);
            if (hex.length() > 2) {
                hex = hex.substring(hex.length() - 2);
            }
            if ((hex = hex.toUpperCase()).length() == 1) {
                hex = "0" + hex;
            }
            Color color = this.paletteService.getByHexValue(hex);
            img.setRGB(x, y, color.getRGB());
            if (++x == Width) {
                x = 0;
                ++y;
            }
            if (y == Height) break;
        }
        BufferedImage rendImage = img;
        ImageIO.write((RenderedImage)rendImage, "bmp", new File(outputPath));
    }
}

