/*
 * Decompiled with CFR 0.152.
 */
package adboards;

import adboards.AdboardToSprConverter;
import adboards.AdboardsToBmpConverter;
import java.io.IOException;
import tools.BinaryService;

public class AdboardsService {
    private static final String OUTPUT_BMP_FILE_PATH = "Adboards.bmp";
    private static final String OUTPUT_SPR_FILE_PATH = "Adboards.spr";
    private static final int ADDBOARDS_IMAGE_WIDTH = 85;
    private static final int ADDBOARDS_IMAGE_HEIGHT = 2244;
    private final AdboardsToBmpConverter addBoardToBmpConverter;
    private final AdboardToSprConverter addBoardToSprConverter;
    private final BinaryService binaryExtractor;

    public AdboardsService(AdboardsToBmpConverter addBoartToBmpConverter, AdboardToSprConverter addBoardToSprConverter, BinaryService binaryExtractor) {
        this.addBoardToBmpConverter = addBoartToBmpConverter;
        this.addBoardToSprConverter = addBoardToSprConverter;
        this.binaryExtractor = binaryExtractor;
    }

    public void convertToBmp() throws IOException, Exception {
        this.addBoardToBmpConverter.convert(this.binaryExtractor.getFileContent(OUTPUT_SPR_FILE_PATH), 85, 2244, OUTPUT_BMP_FILE_PATH);
    }

    public void convertToSpr() throws IOException, Exception, Throwable {
        this.binaryExtractor.writeHexString(OUTPUT_SPR_FILE_PATH, this.addBoardToSprConverter.convert(OUTPUT_BMP_FILE_PATH, 85, 2244));
    }
}

