/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import main.Kernel;

public class USMTextureManager
extends JFrame {
    private JLabel PitchLabel;
    private JList<String> PitchList;
    private JLabel addboardsLabel;
    private JButton addboardsToBmpButton;
    private JButton addboardsToSprButton;
    private JCheckBox autoColorEnabledCheckbox;
    private JTextArea consoleBox;
    private JButton exitButton;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTextArea jTextArea1;
    private JCheckBox logEnabledCheckbox;
    private JButton pitchToBmpButton;
    private JButton pitchToSprButton;

    public USMTextureManager() {
        this.initComponents();
        ImageIcon img = new ImageIcon("mainIcon.png");
        this.setIconImage(img.getImage());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.addboardsLabel = new JLabel();
        this.addboardsToBmpButton = new JButton();
        this.addboardsToSprButton = new JButton();
        this.exitButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.consoleBox = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.PitchList = new JList();
        this.PitchLabel = new JLabel();
        this.pitchToBmpButton = new JButton();
        this.pitchToSprButton = new JButton();
        this.autoColorEnabledCheckbox = new JCheckBox();
        this.logEnabledCheckbox = new JCheckBox();
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.setDefaultCloseOperation(3);
        this.setTitle("USM98 Textures Manager 1.1.1");
        this.addboardsLabel.setFont(new Font("Lucida Grande", 3, 13));
        this.addboardsLabel.setText("Adboards");
        this.addboardsToBmpButton.setText("Export to BMP");
        this.addboardsToBmpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                USMTextureManager.this.addboardsToBmpButtonActionPerformed(evt);
            }
        });
        this.addboardsToSprButton.setText("Export to SPR");
        this.addboardsToSprButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                USMTextureManager.this.addboardsToSprButtonActionPerformed(evt);
            }
        });
        this.exitButton.setText("Exit");
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                USMTextureManager.this.exitButtonActionPerformed(evt);
            }
        });
        this.consoleBox.setEditable(false);
        this.consoleBox.setColumns(20);
        this.consoleBox.setRows(5);
        this.jScrollPane2.setViewportView(this.consoleBox);
        this.PitchList.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Normal left", "Normal right", "Snow left", "Snow right", "Winter left", "Winter right", "Wet left", "Wet right"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane3.setViewportView(this.PitchList);
        this.PitchLabel.setFont(new Font("Lucida Grande", 3, 13));
        this.PitchLabel.setText("Pitch");
        this.pitchToBmpButton.setText("Export to BMP");
        this.pitchToBmpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                USMTextureManager.this.pitchToBmpButtonActionPerformed(evt);
            }
        });
        this.pitchToSprButton.setText("Export to SPR");
        this.pitchToSprButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                USMTextureManager.this.pitchToSprButtonActionPerformed(evt);
            }
        });
        this.autoColorEnabledCheckbox.setText("Enable auto-color");
        this.autoColorEnabledCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                USMTextureManager.this.autoColorEnabledCheckboxActionPerformed(evt);
            }
        });
        this.logEnabledCheckbox.setText("Enable logs");
        this.logEnabledCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                USMTextureManager.this.logEnabledCheckboxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, -2, 423, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addboardsLabel).addComponent(this.PitchLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pitchToBmpButton, -1, -1, Short.MAX_VALUE).addComponent(this.pitchToSprButton, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.addboardsToBmpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addboardsToSprButton)))).addGap(158, 158, 158))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(127, 127, 127).addComponent(this.autoColorEnabledCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logEnabledCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.exitButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.addboardsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addboardsToBmpButton).addComponent(this.addboardsToSprButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.PitchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane3, -2, -1, -2).addGap(33, 33, 33).addComponent(this.jScrollPane2, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.pitchToBmpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pitchToSprButton))).addGap(58, 58, 58).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoColorEnabledCheckbox).addComponent(this.logEnabledCheckbox).addComponent(this.exitButton))));
        this.pack();
    }

    private void addboardsToBmpButtonActionPerformed(ActionEvent evt) {
        this.triggerActionToKernel("addboardsToBmp", "This conversion usually takes a few seconds.", 0);
    }

    private void exitButtonActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void addboardsToSprButtonActionPerformed(ActionEvent evt) {
        this.triggerActionToKernel("addboardsToSpr", "This conversion usually takes around one minute.", 0);
    }

    private void pitchToBmpButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.PitchList.getSelectedIndex();
        if (selectedIndex == -1) {
            this.showErrorBox("You must select a pitch to be converted!");
            return;
        }
        this.triggerActionToKernel("pitchToBmp", "This conversion usually takes a few seconds.", selectedIndex);
    }

    private void pitchToSprButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.PitchList.getSelectedIndex();
        if (selectedIndex == -1) {
            this.showErrorBox("You must select a pitch to be converted!");
            return;
        }
        this.triggerActionToKernel("pitchToSpr", "This conversion usually takes a few seconds.", selectedIndex);
    }

    private void autoColorEnabledCheckboxActionPerformed(ActionEvent evt) {
    }

    private void logEnabledCheckboxActionPerformed(ActionEvent evt) {
    }

    private void triggerActionToKernel(String action, String message, int param1) {
        try {
            this.process(action, message, param1, this.logEnabledCheckbox.isSelected(), this.autoColorEnabledCheckbox.isSelected());
        }
        catch (InterruptedException ex) {
            this.showErrorBox("Impossible to perform operation: " + ex.getMessage());
        }
    }

    void process(String action, String message, int param1, boolean logEnabled, boolean autocolorSelectionEnabled) throws InterruptedException {
        this.consoleBox.setText("");
        this.log("Starting process...");
        this.log(message);
        this.enableUi(false);
        Kernel kernel = new Kernel(this, logEnabled, autocolorSelectionEnabled);
        kernel.setAction(action);
        kernel.setParam1(param1);
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        Thread kernelThread = new Thread(() -> kernel.start());
        executor.schedule(kernelThread, 0L, TimeUnit.MILLISECONDS);
    }

    public void log(String msg) {
        this.consoleBox.append(msg + "\n");
    }

    public void enableUi(Boolean status) {
        this.addboardsToBmpButton.setEnabled(status);
        this.addboardsToSprButton.setEnabled(status);
        this.pitchToBmpButton.setEnabled(status);
        this.pitchToSprButton.setEnabled(status);
    }

    private void showErrorBox(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Message", 0);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(USMTextureManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(USMTextureManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(USMTextureManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(USMTextureManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new USMTextureManager().setVisible(true);
            }
        });
    }
}

