/*
 * Decompiled with CFR 0.152.
 */
package pitch;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import pitch.tools.ColorSequence;
import pitch.tools.SequencesContainer;
import tools.LoggerService;
import tools.PaletteService;
import tools.ValueCounter;

public class PitchToSprConverter {
    private BufferedImage image;
    private String dominantColor1;
    private String dominantColor2;
    private int width;
    private int height;
    private String hexStringToOutPut = "";
    private final LoggerService logger;
    private final PaletteService paletteService;

    public PitchToSprConverter(LoggerService logger, PaletteService paletteService) {
        this.logger = logger;
        this.paletteService = paletteService;
    }

    public String convert(String bmpFilePath, int width, int height) throws Exception, Throwable {
        File file = new File(bmpFilePath);
        try {
            this.image = ImageIO.read(file);
        }
        catch (IOException ex) {
            throw new Exception("Image file not found: " + bmpFilePath);
        }
        this.width = width;
        this.height = height;
        if (this.image.getWidth() != width || this.image.getHeight() != height) {
            throw new Exception("Image must have a width of  " + width + " pixels and height must be of  " + height + "!");
        }
        if (this.image.getType() != 5) {
            throw new Exception("Image must be a valid BMP file!");
        }
        String[] chunks = this.parseFile();
        boolean hasSwitched = false;
        SequencesContainer container = new SequencesContainer();
        ColorSequence currentSequence = new ColorSequence();
        String previousColor = "";
        for (String currentColor : chunks) {
            if (!previousColor.equals(currentColor)) {
                if (hasSwitched) {
                    currentSequence = this.handleSequence(container, currentSequence);
                    hasSwitched = false;
                }
                currentSequence.add(currentColor);
            } else {
                if (!hasSwitched) {
                    if (currentSequence.getLastElement().equals(currentColor)) {
                        currentSequence.removeLastElement();
                    }
                    currentSequence = this.handleSequence(container, currentSequence);
                    hasSwitched = true;
                    currentSequence.add(currentColor);
                }
                currentSequence.add(currentColor);
                if ((currentColor.equals(this.dominantColor1) || currentColor.equals(this.dominantColor2)) && currentSequence.getSize() == 63 || !currentColor.equals(this.dominantColor1) && !currentColor.equals(this.dominantColor2) && currentSequence.getSize() == 16) {
                    currentSequence = this.handleSequence(container, currentSequence);
                    currentColor = "";
                }
            }
            previousColor = currentColor;
        }
        this.handleSequence(container, currentSequence);
        int bytesCount = container.getBytesCount();
        if (bytesCount != this.width * this.height) {
            throw new Exception("Extraction failed: we extracted a total of " + bytesCount + " colors in this file");
        }
        for (int i = 0; i < container.getSequencesCount(); ++i) {
            ColorSequence sequence = container.getSequence(i);
            if (sequence.isUniqueColor()) {
                this.outputDuplication(sequence.getFirstElement(), sequence.getSize());
                continue;
            }
            this.outputSequence(sequence);
        }
        int totalLength = (this.hexStringToOutPut.length() + 16) / 2;
        String hexLength = Integer.toHexString(totalLength);
        this.logger.log("Total length: " + totalLength + " bytes (" + hexLength + ").");
        this.paletteService.outputNotFounds();
        return "50414B32000" + hexLength + this.dominantColor1 + this.dominantColor2 + this.hexStringToOutPut;
    }

    private void outputSequence(ColorSequence currentSequence) throws Exception {
        if (currentSequence.getSize() == 0) {
            return;
        }
        int localCount = 0;
        ColorSequence newSequence = new ColorSequence();
        for (String color : currentSequence) {
            newSequence.add(color);
            if (++localCount != 64) continue;
            localCount = 0;
            this.processColorSequence(newSequence);
        }
        if (newSequence.getSize() != 0) {
            this.processColorSequence(newSequence);
        }
        currentSequence.clear();
    }

    private void processColorSequence(ColorSequence newSequence) {
        int cValue = newSequence.getSize() + 191;
        this.hexStringToOutPut = this.hexStringToOutPut + Integer.toHexString(cValue);
        for (String colorElement : newSequence) {
            this.hexStringToOutPut = this.hexStringToOutPut + colorElement;
        }
        newSequence.clear();
    }

    private void outputDuplication(String color, int count) throws IOException {
        this.hexStringToOutPut = color.equals(this.dominantColor1) ? this.hexStringToOutPut + Integer.toHexString(count + 63) : (color.equals(this.dominantColor2) ? this.hexStringToOutPut + Integer.toHexString(count + 127) : this.hexStringToOutPut + "0" + Integer.toHexString(count - 1) + color);
    }

    private ColorSequence handleSequence(SequencesContainer container, ColorSequence currentSequence) throws IOException {
        if (currentSequence.getSize() != 0) {
            container.add(currentSequence);
        }
        return new ColorSequence();
    }

    private String[] parseFile() throws IOException {
        HashMap<String, Integer> colorsIndex = new HashMap<String, Integer>();
        String[] chunks = new String[this.height * this.width];
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                Color color = new Color(this.image.getRGB(x, y), true);
                String colorString = this.paletteService.getByColor(color);
                if (colorsIndex.containsKey(colorString)) {
                    colorsIndex.put(colorString, (Integer)colorsIndex.get(colorString) + 1);
                } else {
                    colorsIndex.put(colorString, 1);
                }
                chunks[index] = colorString;
                ++index;
            }
        }
        ValueCounter biggestOne = new ValueCounter();
        ValueCounter biggestTwo = new ValueCounter();
        for (String key : colorsIndex.keySet()) {
            if ((Integer)colorsIndex.get(key) > biggestOne.getCount()) {
                biggestTwo = biggestOne;
                biggestOne = new ValueCounter();
                biggestOne.setValue(key);
                biggestOne.setCount((Integer)colorsIndex.get(key));
                continue;
            }
            if ((Integer)colorsIndex.get(key) <= biggestTwo.getCount()) continue;
            biggestTwo.setValue(key);
            biggestTwo.setCount((Integer)colorsIndex.get(key));
        }
        this.dominantColor1 = biggestOne.getValue();
        this.dominantColor2 = biggestTwo.getValue();
        this.logger.log("Dominant color #1: " + this.dominantColor1);
        this.logger.log("Dominant color #2: " + this.dominantColor2);
        return chunks;
    }
}

