/*
 * Decompiled with CFR 0.152.
 */
package pitch;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import tools.LoggerService;
import tools.PaletteService;

public class PitchToBmpConverter {
    private boolean cMode = false;
    private boolean duplicateDominantColor1 = false;
    private boolean duplicateDominantColor2 = false;
    private boolean standardMode = false;
    private int x = 0;
    private int y = 0;
    private int width = 0;
    private int printedPixels = 0;
    private BufferedImage img;
    private final LoggerService logger;
    private final PaletteService paletteService;
    private int height;

    public PitchToBmpConverter(LoggerService logger, PaletteService paletteService) {
        this.logger = logger;
        this.paletteService = paletteService;
    }

    public void convert(byte[] fileContent, int Width, int Height, String outputPath) throws IOException {
        this.width = Width;
        this.height = Height;
        this.img = new BufferedImage(Width, Height, 1);
        String dominantColor1 = this.getHexValue(fileContent[8]);
        String dominantColor2 = this.getHexValue(fileContent[9]);
        boolean mod = false;
        int qty = 0;
        int cModeCount = 0;
        this.logger.log("Starting process. Dominant colors are " + dominantColor1 + " and " + dominantColor2);
        for (int i = 10; i < fileContent.length; ++i) {
            int currentByte = fileContent[i];
            String hex = this.getHexValue(currentByte);
            currentByte = (int)Long.parseLong(hex, 16);
            this.logger.log("Current value : " + currentByte + " - in hex: " + hex + " at " + i);
            if (!mod) {
                if (currentByte >= 192 && currentByte <= 255) {
                    qty = 1;
                    this.logger.log("To Cx mode : " + currentByte);
                    cModeCount = currentByte - 191;
                    this.cMode = true;
                    continue;
                }
                if (!this.isDuplicationModeEnabled() && currentByte >= 64 && currentByte <= 127) {
                    this.logger.log("To Dominant color 1 mode : " + currentByte);
                    this.duplicateDominantColor1 = true;
                    mod = true;
                    qty = currentByte - 63;
                } else if (!this.isDuplicationModeEnabled() && currentByte >= 128 && currentByte <= 191) {
                    this.logger.log("To Dominant color 2 mode : " + currentByte);
                    this.duplicateDominantColor2 = true;
                    qty = currentByte - 127;
                    mod = true;
                } else if (!this.isModeEnabled()) {
                    this.logger.log("To Standard  mode : " + currentByte);
                    this.standardMode = true;
                    mod = false;
                }
            }
            if (!mod && this.standardMode) {
                qty = currentByte + 1;
                mod = true;
                continue;
            }
            if (this.isDuplicatingDominantColorEnabled()) {
                if (this.duplicateDominantColor1) {
                    hex = dominantColor1;
                }
                if (this.duplicateDominantColor2) {
                    hex = dominantColor2;
                }
            }
            if (this.isDuplicationModeEnabled() && --cModeCount == 0) {
                this.cMode = false;
            }
            if (this.isDuplicationModeEnabled()) {
                this.disableAllModes();
                this.cMode = true;
            } else {
                this.disableAllModes();
            }
            try {
                this.draw(hex, qty);
            }
            catch (IOException e) {
                this.outputImage(outputPath);
                this.logger.log("An error was raised. Current coordinates are: " + this.x + " - " + this.y);
                throw e;
            }
            mod = false;
            if (this.isDuplicationModeEnabled()) {
                qty = 1;
                mod = true;
            }
            if (this.y >= Height) break;
        }
        this.outputImage(outputPath);
    }

    private void outputImage(String outputPath) throws IOException {
        BufferedImage rendImage = this.img;
        ImageIO.write((RenderedImage)rendImage, "bmp", new File(outputPath));
    }

    private String getHexValue(int currentByte) {
        String hex = Integer.toHexString(currentByte);
        if (hex.length() > 2) {
            hex = hex.substring(hex.length() - 2);
        }
        if ((hex = hex.toUpperCase()).length() == 1) {
            hex = "0" + hex;
        }
        return hex;
    }

    private boolean isModeEnabled() {
        return this.cMode || this.duplicateDominantColor1 || this.duplicateDominantColor2 || this.standardMode;
    }

    private boolean isDuplicationModeEnabled() {
        return this.cMode;
    }

    private boolean isDuplicatingDominantColorEnabled() {
        return this.duplicateDominantColor1 || this.duplicateDominantColor2;
    }

    private void disableAllModes() {
        this.cMode = false;
        this.duplicateDominantColor1 = false;
        this.duplicateDominantColor2 = false;
        this.standardMode = false;
    }

    private boolean isEndOfLine() throws IOException {
        this.logger.log(this.printedPixels + " pixels draw so far (of " + this.width + ")");
        if (this.printedPixels == this.width) {
            this.logger.log("Triggering new line");
            this.x = 0;
            ++this.y;
            this.printedPixels = 0;
            return true;
        }
        return false;
    }

    private void draw(String hex, int qty) throws IOException {
        Color color = this.paletteService.getByHexValue(hex);
        this.logger.log("Wrinting " + qty + "  *  " + hex + " at " + this.x + " " + this.y);
        int qtyCpy = qty;
        while (qtyCpy > 0) {
            if (this.y >= this.height) {
                this.logger.log("Woops! We excedeed the max height of the file!");
                return;
            }
            this.img.setRGB(this.x, this.y, color.getRGB());
            ++this.printedPixels;
            ++this.x;
            if (!this.isEndOfLine() || (qty = --qtyCpy) <= 0) continue;
            this.draw(hex, qty);
            qtyCpy = 0;
        }
    }
}

