/*
 * Decompiled with CFR 0.152.
 */
package usm9899tweaker;

import java.awt.Container;
import java.awt.Desktop;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import usm9899tweaker.PatchGame;

public class MainMenu
implements ActionListener {
    private JFrame mainMenu;
    private static final JButton patchGameButton = new JButton("Patch menu");
    private static final JButton aboutButton = new JButton("About");
    private static final JButton quitButton = new JButton("Exit");
    public static String iconName = "mainIcon.png";

    public MainMenu() {
        System.out.println("\nCreating main window");
    }

    private void displayRTFM() {
        File f = new File("options.rtfm");
        if (!f.exists() && !f.isDirectory()) {
            boolean response;
            String question = "Did you read the awesome, clear and concise documentation?";
            int result = JOptionPane.showConfirmDialog(this.mainMenu, question, "RTFM", 0);
            boolean bl = response = result != 1;
            if (response) {
                JOptionPane.showMessageDialog(this.mainMenu, "Thank you, you're a good guy / girl", "Gracias", 1);
            } else {
                try {
                    Desktop.getDesktop().open(new File("documentation.html"));
                }
                catch (IOException ex) {
                    Logger.getLogger(MainMenu.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            try {
                PrintWriter writer = new PrintWriter("options.rtfm", "UTF-8");
                writer.close();
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    public void createWindow() {
        this.mainMenu = new JFrame();
        this.mainMenu.setTitle("USM 98-99 Tweaker v1.3");
        this.mainMenu.setSize(270, 220);
        this.mainMenu.setLocation(250, 250);
        this.mainMenu.setResizable(false);
        ImageIcon img = new ImageIcon(iconName);
        this.mainMenu.setIconImage(img.getImage());
        Container windowContent = this.mainMenu.getContentPane();
        windowContent.setLayout(new GridLayout(3, 1));
        windowContent.add(patchGameButton);
        patchGameButton.addActionListener(this);
        windowContent.add(aboutButton);
        aboutButton.addActionListener(this);
        windowContent.add(quitButton);
        quitButton.addActionListener(this);
        this.mainMenu.setVisible(true);
        this.mainMenu.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        this.displayRTFM();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == patchGameButton) {
            PatchGame patcher = new PatchGame(this.mainMenu);
            try {
                patcher.launch();
            }
            catch (Exception ex) {
                this.showErrorMessage("An error was encountered. This is the log trace: " + ex.getMessage());
                Logger.getLogger(MainMenu.class.getName()).log(Level.SEVERE, null, ex);
                this.mainMenu.setEnabled(true);
            }
        }
        if (ev.getSource() == aboutButton) {
            this.showAboutBox();
        }
        if (ev.getSource() == quitButton) {
            this.exit();
        }
    }

    private void exit() {
        System.exit(0);
    }

    private void showAboutBox() {
        String auth = "e.courtial";
        String message = "This software is realeased without any garantee or support.";
        message = message + "\nThe source code is available on GitHub, so feel free to contribute.";
        message = message + "\nAuthor: The USM Community, since 2017.";
        message = message + "\n\nContributors: Ande PEARSON, Christian SMITH (Pseudo), Dane SMALLBONE, Florian DEBORTOLI, Eric COURTIAL";
        message = message + "\nSpecial thanks to the game dev's team for having created the USM series.";
        JOptionPane.showMessageDialog(this.mainMenu, message, "About", 1);
    }

    private void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(this.mainMenu, message, "Error", 0);
    }
}

