/*
 * Decompiled with CFR 0.152.
 */
package tools.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class BinaryFileHelper {
    private RandomAccessFile binaryFile = null;
    private String filePath = "";
    private long fileLenght = 0L;
    private static BinaryFileHelper instance = null;

    protected void BinaryFileHelper() {
    }

    public static BinaryFileHelper getInstance() {
        if (instance == null) {
            instance = new BinaryFileHelper();
        }
        return instance;
    }

    public void setFilePath(String path) {
        this.filePath = path;
    }

    public void openFile() throws FileNotFoundException {
        File file = new File(this.filePath);
        this.fileLenght = file.length();
        this.binaryFile = new RandomAccessFile(file, "rw");
    }

    public void closeFile() throws IOException {
        this.binaryFile.close();
    }

    public RandomAccessFile getFile() {
        return this.binaryFile;
    }

    public byte[] getFilePart(long startingPos, int lenght) throws IOException {
        this.binaryFile.seek(startingPos);
        byte[] buffer = new byte[lenght];
        this.binaryFile.read(buffer);
        return buffer;
    }

    public String integerToHex(int value) {
        return Integer.toHexString(value);
    }

    public String longToHex(long value) {
        return Long.toHexString(value);
    }

    public Integer hexToInt(String value) {
        return (int)Long.parseLong(value, 16);
    }

    public Long hexToLong(String value) {
        return Long.parseLong(value, 16);
    }

    public void goToByte(int position) throws IOException {
        this.binaryFile.seek(position);
    }

    public void goToByte(long position) throws IOException {
        this.binaryFile.seek(position);
    }

    public void writeIntValue(int value) throws IOException {
        this.binaryFile.write(value);
    }

    public void writeHex(String value) throws IOException {
        this.binaryFile.writeBytes(value);
    }

    public String binaryToText(byte[] array) {
        return new String(array);
    }

    public List<Long> getStringPosition(String search) throws IOException {
        return this.getStringPosition(search, 0L);
    }

    public List<Long> getStringPosition(String search, long startPosition) throws IOException {
        int stringLenght = search.length();
        ArrayList<Long> results = new ArrayList<Long>();
        while (startPosition < this.fileLenght - (long)stringLenght) {
            this.goToByte(startPosition);
            String currentBlock = this.binaryToText(this.getFilePart(startPosition, stringLenght));
            if (currentBlock.contentEquals(search)) {
                System.out.println("\nPosition: " + startPosition + " (" + this.longToHex(startPosition) + ")");
                System.out.println(currentBlock);
                results.add(startPosition);
            }
            ++startPosition;
        }
        return results;
    }

    public String getFileCheckSum() throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        int nread;
        MessageDigest md = MessageDigest.getInstance("SHA1");
        FileInputStream fis = new FileInputStream(this.filePath);
        byte[] dataBytes = new byte[1024];
        while ((nread = fis.read(dataBytes)) != -1) {
            md.update(dataBytes, 0, nread);
        }
        byte[] mdbytes = md.digest();
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < mdbytes.length; ++i) {
            sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        String checksum = sb.toString();
        System.out.println("Digest(in hex format):: " + checksum);
        return checksum;
    }

    public long geFileLength() {
        return this.fileLenght;
    }
}

